<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class User extends Model 
{

    protected $table = 'users';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name', 'email', 'phone', 'gender', 'national_id', 'birthday');

    public function orders()
    {
        return $this->hasMany('Order');
    }

    public function answers()
    {
        return $this->hasMany('Answer');
    }

    public function attachments()
    {
        return $this->hasMany('Attachment');
    }

    public function picture()
    {
        return $this->hasOne('Picture');
    }

}